Triggers = {}
CollectionsUsed = {3, 12}
moving_ephemera = {}
MAX_RENDERED_COUNT = 1400

function Triggers.init()
    gore_enabled = Game.version > "20200904"
    ephemera_count = 0
    max_ephemera = math.ceil(#Ephemera / 2) -- Leave room for other types of ephemera
    nonticks = {}
    for m in Monsters() do
        if not m.player and m.type ~= "kamikaze tick" and m.type ~= "minor tick" and m.type ~= "major tick" then
            table.insert(nonticks, m)
        end
    end

    for m in MonsterTypes() do
        if m.class == "tick" then
            for c in MonsterClasses() do
                m.enemies[c] = false
                m.friends[c] = true
            end

            m.enemies["player"] = true
            m.friends["player"] = false
        end
    end

    for p in Players() do
        if p.items["pistol"] ~= 0 and p.items["pistol ammo"] < 7 then
            p.items["pistol ammo"] = 7
        end
    end

    tick_ct = 0
end

function Triggers.idle()
    -- if Game.ticks % 30 == 0 then
    --     MonsterTypes["minor tick"].clut_index = 2
    --     MonsterTypes["major tick"].clut_index = 2
    --     MonsterTypes["kimikaze tick"].clut_index = 2
    -- end

    for i = #nonticks, 1, -1 do
        local m = nonticks[i]
        if m and m.valid then
            if m.active and not m._active then
                m._active = Game.ticks + 20 + Game.random(20)
            end

            if m._active == Game.ticks then
                for i = 1, 3 do
                    local height = (i - 1) * .3
                    local t = Monsters.new(m.x, m.y, m.z + height, m.polygon, "kamikaze tick")
                    if t then
                        t.active = true
                    end
                end
                m.polygon:play_sound(m.x, m.y, m.z, "rocket exploding", .1)
                m:damage(m.life + 1)
                if gore_enabled then
                    explode_monster(m, 1)
                end
                table.remove(nonticks, i)
            end
        else
            table.remove(nonticks, i)
        end
    end

    if gore_enabled then
        for i = #moving_ephemera, 1, -1 do
            local e = update_ephemera(moving_ephemera[i])
            if not e then
                table.remove(moving_ephemera, i)
            end
        end

        -- Try to keep frame rate high
        if Game.ticks % 30 == 0 then
            cleanup_ephemera_in_view()
        end
    end
end

function Triggers.monster_killed(monster, aggressor_player, projectile)
    if monster.type.class == "tick" then
        if projectile then
            local explode = 0
            if
                projectile.type == "grenade" or projectile.type == "compiler bolt minor" or
                    projectile.type == "compiler bolt major" or
                    projectile.type == "fusion bolt major" or
                    projectile.type == "juggernaut rocket" or
                    projectile.type == "trooper grenade" or
                    projectile.type == "juggernaut missile" or
                    projectile.type == "overloaded fusion disperal"
             then
                explode = 1
             elseif projectile.type == "missile" then
                explode = 2
            end

            explode_monster(monster, explode, projectile.facing)
        else
            explode_monster(monster, 1)
        end
    end
end

function explode_monster(m, explode, proj_facing)
    if Ephemera.quality == "off" then
        return
    end

    local col, seq, ct, num = get_ephemera_by_monster(m)

    if Ephemera.quality == "ultra" then
        num = num * 4
    elseif Ephemera.quality == "high" then
        num = num * 2
    elseif Ephemera.quality == "low" then
        num = math.ceil(num * .5)
    end

    if col and seq and ct then
        for i = 1, num do
            if explode == 3 then
                col, seq, ct = get_ephemera_by_flaming_death(m)
            else
                col, seq, ct, num = get_ephemera_by_monster(m)
            end
            local facing = nil
            if proj_facing and m.type.class ~= "compiler" then
                local rand = -45 + Game.random_local(90)
                facing = proj_facing + rand
            else
                facing = Game.random_local(360)
            end
            local e = create_ephemera(m.x, m.y, m.z + .2 + Game.random_local(5) / 10.0, m.polygon, col, seq, facing)

            if e then
                table.insert(moving_ephemera, e)

                if m.type == "mother of all cyborgs" or m.type == "mother of all hunters" then
                    e.enlarged = true
                end

                e._horizontal_dist = Game.random_local(100) / 750.0
                if explode == 1 then
                    e._vertical_velocity = .05 + (Game.random_local(5) / 100.0)
                elseif explode == 2 then
                    e._vertical_velocity = .08 + (Game.random_local(5) / 100.0)
                    e._horizontal_dist = (50 + Game.random_local(50)) / 300.0
                elseif explode == 3 then
                    e._vertical_velocity = .02
                else
                    e._vertical_velocity = .01
                end
                e._vertical_velocity_step = -.002
                e._terminal_velocity = -.09
                e._max_bounces = 2
                e._bounces = 0
                e._moving_horizontally = true
                e._active = true
                e.clut_index = ct

                if m.type.class == "compiler" then
                    local z = m.z + (Game.random_local(85) / 100)
                    e:position(e.x, e.y, z, e.polygon)
                    e._vertical_velocity = Game.random_local(15) / 1000
                    if Game.random_local(2) == 0 then
                        e._vertical_velocity = e._vertical_velocity * -1
                    end
                    e._vertical_velocity_step = 0
                    e._terminal_velocity = 0
                    e._horizontal_dist = .005 + (Game.random_local(10) / 1000)
                end

                if m.type.class == "defender" then
                    e._delete_tick = Game.ticks + 35
                elseif m.type.class == "compiler" then
                    e._delete_tick = Game.ticks + 5 + Game.random_local(40)
                end
            end
        end
    end
end

function update_ephemera(e)
    if not e._active then
        return nil
    end

    if e._delete_tick and e._delete_tick == Game.ticks then
        e:delete()
        return nil
    end

    if e.z > e.polygon.floor.z or e._vertical_velocity > 0 then
        local vv = e._vertical_velocity + e._vertical_velocity_step
        if vv < e._terminal_velocity then
            vv = e._terminal_velocity
        end
        e._vertical_velocity = vv
        local z = e.z + e._vertical_velocity

        if z > e.polygon.ceiling.z then
            z = e.polygon.ceiling.z
        elseif z < e.polygon.floor.z then
            z = e.polygon.floor.z
        end

        local x = e.x
        local y = e.y
        local poly = e.polygon
        x, y, poly = get_offset_location(e.x, e.y, e.z, e.polygon, e.facing, e._horizontal_dist)

        -- If hit a wall, try picking a new random direction to move in
        if not poly then
            local chdir = 90 + Game.random_local(45)
            if Game.random_local(2) == 0 then
                chdir = chdir * -1
            end
            e.facing = e.facing + chdir

            x, y, poly = get_offset_location(e.x, e.y, e.z, e.polygon, e.facing, e._horizontal_dist)

            if poly then
                e._horizontal_dist = e._horizontal_dist / 6
                if e._vertical_velocity > 0 then
                    e._vertical_velocity = e._vertical_velocity / 2
                end
            end
        end

        if not poly then
            x, y, poly = e.x, e.y, e.polygon
        end

        if poly then
            e:position(x, y, z, poly)
        end

        return e
    elseif e._delete_tick then
        return e
    elseif e._vertical_velocity <= -.09 then
        e._vertical_velocity = .03
        return e
    else
        e._active = false
        return nil
    end
end

function create_ephemera(x, y, z, polygon, col, seq, facing)
    if ephemera_count >= max_ephemera then
        cleanup()
    end

    local e = Ephemera.new(x, y, z, polygon, col, seq, facing)
    if not e then
        cleanup()
        e = Ephemera.new(x, y, z, polygon, col, seq, facing)
    end
    if e then
        ephemera_count = ephemera_count + 1
        e._owner = BRUTAL_MARATHON_OWNER
    end
    return e
end

function cleanup_ephemera_in_view()
    local rendered_ephemera = {}
    for e in Ephemera() do
        if e._owner == BRUTAL_MARATHON_OWNER and e.rendered and not e._active then
            table.insert(rendered_ephemera, e)
        end
    end

    -- Players.print("Rendered: " .. #rendered_ephemera .. ", total: " .. ephemera_count)
    if #rendered_ephemera > MAX_RENDERED_COUNT then
        cleanup(rendered_ephemera)
    end
end

function cleanup(ephemera)
    local count = 0

    if ephemera then
        for i = #ephemera, 1, -1 do
            local e = ephemera[i]
            if count % 3 == 0 and e and e._owner == BRUTAL_MARATHON_OWNER and not e._active then
                e:delete()
                ephemera_count = ephemera_count - 1
            end
            count = count + 1
        end
    else
        for e in Ephemera() do
            if count % 3 == 0 and e and e._owner == BRUTAL_MARATHON_OWNER and not e._active then
                e:delete()
                ephemera_count = ephemera_count - 1
            end
            count = count + 1
        end
    end
end

function get_offset_location(x, y, z, polygon, angle, dist)
    local nx, ny = calc_offset_location(x, y, angle, dist)
    local poly = polygon:find_polygon(x, y, nx, ny)

    -- Don't move into polygons if the floor or ceiling block the movement
    if poly and (z <= poly.floor.height or z >= poly.ceiling.height) then
        poly = nil
    end

    return nx, ny, poly
end

function calc_offset_location(x, y, angle, dist)
    angle = angle * math.pi / 180
    return x + math.cos(angle) * dist, y + math.sin(angle) * dist
end

function get_poly_recurse(start_poly, startx, starty, destx, desty, z, depth)
    local line = start_poly:find_line_crossed_leaving(startx, starty, destx, desty)
    if line then
        if line.cw_polygon == start_poly and line.ccw_polygon then
            newpoly = line.ccw_polygon
        elseif line.ccw_polygon == start_poly and line.cw_polygon then
            newpoly = line.cw_polygon
        end

        if newpoly then
            if newpoly:contains(destx, desty) then
                if z > newpoly.floor.height and z < newpoly.ceiling.height then
                    return newpoly
                else
                    return nil
                end
            else
                if depth > 3 then
                    return nil
                end
                return get_poly_recurse(newpoly, newpoly.x, newpoly.y, destx, desty, z, depth + 1)
            end
        else
            return nil
        end
    else
        return nil
    end
end

function get_ephemera_by_monster(m)
    local num = 8
    local col = m.type.collection

    local seq = get_gore_sequence(col)
    local ct = m.type.clut_index

    if m.player then
        ct = m.player.color.index
    end

    if m.type.class == "juggernaut" then
        num = 30
    elseif m.type.class == "tick" then
        num = 5
    elseif m.type.class == "defender" then
        num = 30
    elseif m.type.class == "drone" or m.type.class == "possessed drone" then
        num = 6
    elseif m.type.class == "compiler" then
        num = 50
    elseif m.type == "mother of all cyborgs" or m.type == "mother of all hunters" then
        num = 20
    end

    if col == 7 then -- Items (potato anus, etc)
        num = 0
        seq = nil
    end

    return col, seq, ct, num
end

function get_ephemera_by_flaming_death()
    local col = 4
    local seq = 30 + Game.random_local(4)
    local ct = 0

    return col, seq, ct
end

function get_gore_sequence(col)
    if col == 9 then
        return 13
    elseif col == 2 then
        return 9 + Game.random_local(2)
    elseif col == 3 then
        return 7 + Game.random_local(2)
    elseif col == 5 then
        return 11 + Game.random_local(2)
    elseif col == 8 then
        if Game.random_local(2) == 0 then
            return 10
        end
        return 12
    elseif col == 10 then
        return 9
    elseif col == 11 then
        return 14 + Game.random_local(2)
    elseif col == 12 then
        local rand = Game.random_local(3)
        if rand == 0 then
            return 13
        elseif rand == 1 then
            return 15
        end
        return 16
    elseif col == 14 then
        return 8 + Game.random_local(2)
    elseif col == 15 then
        return 8 + Game.random_local(2)
    elseif col == 16 then
        return 8
    elseif col == 6 then
        return 35 + Game.random_local(3)
    elseif col == 13 then
        return 14 + Game.random_local(3)
    elseif col == 31 then
        if Game.random_local(2) == 0 then
            return 9
        end
        return 11
    else
        return 9
    end
end

function cheat()
    Players.print("Nobody likes a cheater :C")
    for p in Players() do
        p.items["pistol"] = 2
        p.items["assault rifle"] = 1
        p.items["fusion pistol"] = 1
        p.items["missile launcher"] = 1
        p.items["alien weapon"] = 1
        p.items["flamethrower"] = 1
        p.items["shotgun"] = 2
        p.items["smg"] = 1

        p.items["pistol ammo"] = 50
        p.items["assault rifle ammo"] = 15
        p.items["assault rifle grenades"] = 8
        p.items["fusion pistol ammo"] = 25
        p.items["missile launcher ammo"] = 4
        p.items["flamethrower ammo"] = 3
        p.items["shotgun ammo"] = 80
        p.items["smg ammo"] = 20
    end
end

---- The following functions taken from
---- https://gist.github.com/kirubz/fa84375008d376a2d695618e0ae3aed8/9812f1407136ca1ef795d484162d05ad2c7eb2b8
function angleOfPoint(pt)
    local x, y = pt.x, pt.y
    local radian = math.atan2(y, x)
    local angle = radian * 180 / math.pi
    if angle < 0 then
        angle = 360 + angle
    end
    return angle
end

-- returns the degrees between two points (note: 0 degrees is 'east')
function angle_between_points(a, b)
    local x, y = b.x - a.x, b.y - a.y
    return angleOfPoint({x = x, y = y})
end
----
